import { getServerSession } from 'next-auth';
import { authOptions } from '@/app/api/auth/[...nextauth]/route';
import { redirect } from 'next/navigation';
import { getAnnonceById } from '@/lib/services/annonceService';
import { getUserById } from '@/lib/services/userService';
import Link from 'next/link';

export default async function AnnonceDetail({ params }: { params: { id: string } }) {
    const session = await getServerSession(authOptions);

    if (!session) {
        redirect('/');
    }
    const annonceId = await getAnnonceById(Number(params.id));
    const agent = await getUserById(annonceId?.agentId || 0);
    return (
        <div className="font-sans min-h-screen p-8 sm:p-20 mt-20">
            <header className="mb-8">
                <Link href="/" className="border rounded p-2 hover:bg-gray-100 hover:text-gray-700">Accueil</Link>
                <h1 className="text-4xl font-bold mb-2">{annonceId?.titre}</h1>
                <p className="text-lg text-gray-600">{annonceId?.address}, {annonceId?.ville}, {annonceId?.codePostal}</p>
            </header>
            <main>
                <section className="mb-6">
                    <h2 className="text-2xl font-semibold mb-2">Détails de l'annonce</h2>
                    <p className="text-gray-700">Agent ID: {annonceId?.agentId}</p>
                    <p className="text-gray-700">Description: {annonceId?.description || 'Aucune description disponible.'}</p>
                    <p className="text-gray-700">Prix: {annonceId?.prix} €</p>
                </section>
                <section>
                    <h2 className="text-2xl font-semibold mb-2">Contactez l'agent</h2>
                    <p className="text-gray-700">Pour plus d'informations, veuillez contacter l'agent responsable de cette annonce.</p>
                    {agent ? (
                        <div className="mt-4">
                            <p className="text-gray-700">Nom: {agent.firstName} {agent.lastName}</p>
                            <p className="text-gray-700">Email: {agent.email}</p>
                        </div>
                    ) : (
                        <p className="text-gray-700">Informations sur l'agent non disponibles.</p>
                    )}
                </section>
            </main>
        </div>
    );
}